//	CFileURL.h

#ifndef _H_CFileURL
#define _H_CFileURL

#include "CFile.h"

class CFileUrl : public CFile {
	
	public:
	
	OSErr		IFileUrl(
		CDiskUrl			*urlDiskP, 
		CFolderUrl			*urlParentFolderP, 
		Gen_Item			*itemP, 
		EntryIndex			dirIndexS);
		
	virtual	void		Dispose(void);
	
	virtual	Boolean		IsForked(void);
	
	virtual char		*GetDescription(char *buf);

	virtual ulong		GetPhysicalSize(void);
	virtual ulong		GetLogicalSize(void);

	virtual	DateTimeRec		*GetCreatedTime(DateTimeRec *dt);
	virtual	DateTimeRec		*GetModifiedTime(DateTimeRec *dt);
	virtual	void			SetCreatedTime(DateTimeRec *dt);
	virtual	void			SetModifiedTime(DateTimeRec *dt);
	virtual	void			SetTimeStamps(DateTimeRec *creDate, DateTimeRec *modDate);
	virtual	void			GetTimeStamps(DateTimeRec *creDate, DateTimeRec *modDate);
	virtual	DateTimeRec		*GetModifiedTimeRemote(DateTimeRec *dt);
	virtual	void			RemoteChanged(void);

	virtual	char		*GetName(char *buf);
	virtual	void		SetName(char *buf);

	virtual	OSErr 		ReadFile(Byte *buffer, long length);
	virtual	OSErr 		WriteFile(Byte *buffer, long length);

	virtual ADFS_IconType		GetIconType(void);
	

	virtual	void		GetAccessBits(Gen_AccessBits *bits);
	virtual	void		SetAccessBits(Gen_AccessBits *bits);

	virtual	ulong		ADFS_GetBufSize(void);
	virtual	OSErr		ADFS_Open(
		ADFS_IOType	ioType, 
		Boolean		resForkB, 
		char		**bufferP, 
		ulong		*bufSize);

	virtual	OSErr		ADFS_Read(ushort *bytesRead);
	virtual	OSErr		ADFS_Write(ushort *bytesWritten);
	virtual	OSErr		ADFS_Close(void);

	OSErr	Pro_WriteBlock(
		ushort			numBytesS, 
		Pro_Block		*block);

	virtual	char		*GetStorageStr(char *buf256);
	
	virtual	Boolean		IsDeleted(void);
	virtual	OSErr		Delete(Boolean warnB = FALSE, CDialogCopy *copyP0 = NULL);
	
	virtual	void		Open(void);

	/***************************************/
	Handle			i_iconSuiteH;
	Gen_Item		*i_itemP;
	CGenerator		*i_generatorP;

	private:
	typedef CFile _inherited;
};

#endif
